<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});

// Lightweight FAQ endpoint for the AI/clients
Route::get('/ai/faq', function (Request $request) {
    $q = (string) $request->query('q', '');
    if ($q === '') { return response()->json(['ok' => false, 'error' => 'Missing q'], 422); }
    try {
        $ans = app(\App\Services\FaqService::class)->answerFor($q);
        if (is_string($ans) && $ans !== '') {
            return response()->json(['ok' => true, 'answer' => $ans]);
        }
        return response()->json(['ok' => false, 'answer' => null]);
    } catch (\Throwable $e) {
        return response()->json(['ok' => false, 'error' => 'failed'], 500);
    }
});
